<?php
include './db.php';
include './function.php';

$activities = getAllActivities();
?>
<!DOCTYPE html>
<html lang="en">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">  
    <meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Activities in Ahangama - Villa Effort - Ahangama </title>  
    <meta name="keywords" content="Villa in Ahangama, ahangama villa accommodations, things to do in ahangama, things to do in mirissa, surfing in mirissa, boat safari in koggala, boat safari, whales waching mirissa, mirissa whales waching, galle fort, galle , hikkaduwa, hikkaduwa diving, ahangama surfing, holiday in ahangama, holiday in sri lanka, activities in sri lanka ">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon.png">
    <link rel="stylesheet" type="text/css" href="revolution/css/settings.css">
    <link rel="stylesheet" type="text/css" href="revolution/css/layers.css">
    <link rel="stylesheet" type="text/css" href="revolution/css/navigation.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="css/colors.css">
    <link rel="stylesheet" href="css/custom.css">
</head>
<body> 

    <div id="preloader">
        <img class="preloader" src="images/loader.gif" alt="">
    </div>

    <div id="wrapper">

        <?php include './header.php'; ?>

        <div class="page-parallax parallax parallax-off" data-stellar-background-ratio="1" style="background-image:url('images/banner/activities.jpg');">

        </div>

        <div class="page-title">
            <div class="container">
                <div class="section-title">
                    <h3>Activities</h3>
                    <p class="lead">An opportunity take glimpse of Sri Lanka in wide angle which not only<br> lustrous with more exciting locations. </p>
                </div>
            </div>
        </div>

        <div class="section">
            <div class="container">
                <div class="row team-members gardener-list">

                    <?php
                    foreach ($activities as $activitiy) {
                        ?>
                        <div class="col-md-3 wow fadeIn" style="max-height: 480px;">
                            <div class="about-widget activities">
                                <a href="view-activity.php?id=<?php echo $activitiy['id']; ?>">

                                    <div class="post-media entry">
                                        <img src="images/activities/<?php echo $activitiy['image_name']; ?>" alt="" class="img-responsive img-rounded">

                                    </div>
                                </a>
                                <div class="small-title" style="margin-top: 10px;">
                                    <a href="view-activity.php?id=<?php echo $activitiy['id']; ?>"><h4><?php echo $activitiy['title']; ?></h4></a>
                                </div>
                                <p class="text-justify">
                                    <?php
                                    if (strlen($activitiy['sort_description']) > 0) {
                                        echo substr($activitiy['sort_description'], 0, 100) . '...';
                                    } else {
                                        echo $activitiy['sort_description'];
                                    }
                                    ?>
                                </p>
                                <a class="readmore pull-right" href="view-activity.php?id=<?php echo $activitiy['id']; ?>">Read More</a>
                            </div>
                        </div>
                        <?php
                    }
                    ?>

                </div>
            </div>
        </div>

        <?php include './footer.php'; ?>
    </div>

    <script src="js/all.js"></script>
    <script src="js/custom.js"></script> 

</body>
</html>