<?php
include './header.php';

$imgName = NULL;
$success = NULL;
$error = NULL;

$id = $_GET['id'];

if (isset($_POST['save-data'])) {

    $editRoom = updateOneRoom($_POST, $_FILES);

    if ($editRoom) {
        $success = 'The room details was updated successfully';
    } else {
        $error = 'Something went wrong, please try again ';
    }
}

$room = getOneRoom($id);
?>
<script src="tinymce/js/tinymce/tinymce.min.js"></script>
<script>

    tinymce.init({
        selector: "#description",
        // ===========================================
        // INCLUDE THE PLUGIN
        // ===========================================

        plugins: [
            "advlist autolink lists link image charmap print preview anchor",
            "searchreplace visualblocks code fullscreen",
            "insertdatetime media table contextmenu paste"
        ],
        // ===========================================
        // PUT PLUGIN'S BUTTON on the toolbar
        // ===========================================

        toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image jbimages",
        // ===========================================
        // SET RELATIVE_URLS to FALSE (This is required for images to display properly)
        // ===========================================

        relative_urls: false

    });

</script>
<!-- MAIN SITE WRAPPER-->
<div class="content-wrapper">

    <!--container-->
    <div class="container">
        <!--banner-->
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">Manage Room</h1>
            </div>
        </div>
        <!--end banner-->


        <!--new image add form-->
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        Edit Room - <?php echo $room['title']; ?>
                    </div>
                    <div class="panel-body">
                        <form method="post" action="" enctype="multipart/form-data">

                            <div class="form-group">
                                <?php if (isset($success)) { ?>

                                    <div class="alert alert-success" style="margin-top: 15px ">
                                        <a href="" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                        <strong>Success! </strong> <?php echo $success; ?>
                                    </div>

                                <?php } ?>

                                <?php if (isset($error)) { ?>

                                    <div class="alert alert-danger" style="margin-top: 15px ">
                                        <a href="" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                        <strong>Try again! </strong> <?php echo $error; ?>
                                    </div>

                                <?php } ?>
                            </div>

                            <div class="form-group">
                                <label for="imageName">Select Image</label>
                                <input name="id" value="<?php echo $room['id']; ?>" type="hidden" />
                                <input name="oldImg" value="<?php echo $room['image_name']; ?>" type="hidden" />
                                <input name="image" type="file" id="exampleInputFile" />
                                <p class="help-block">Automaticity cropping this image 360 X 240 pixels</p>
                            </div> 

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" value="<?php echo $room['title']; ?>" class="form-control" id="title" placeholder="Enter Room Name" />
                            </div>  
 

                            <div class="form-group">
                                <label for="price">Price - BB</label>
                                <input type="text" name="price" value="<?php echo $room['price']; ?>" class="form-control" id="price" placeholder="Enter Room Price - BB" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="priceRO">Price - Room Only</label>
                                <input type="text" name="priceRO" value="<?php echo $room['priceRO']; ?>" class="form-control" id="priceRO" placeholder="Enter Room Price - Room Only" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="extraBeds">Number of Extra Beds</label>
                                <input type="text" name="extraBeds" value="<?php echo $room['extraBeds']; ?>" class="form-control" id="extraBeds" placeholder="Enter Number of Extra Beds" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="extraBedPrice">Price of a Extra Bed</label>
                                <input type="text" name="extraBedPrice" value="<?php echo $room['extraBedPrice']; ?>" class="form-control" id="extraBedPrice" placeholder="Enter Price of a Extra Beda" required/>
                            </div>
                             
                            <div class="form-group">
                                <label for="numOfRoom">Number of Rooms</label>
                                <input type="text" name="numOfRoom" value="<?php echo $room['numOfRoom']; ?>" class="form-control" id="numOfRoom" placeholder="Enter Number of Rooms" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="sort_description" >Short Description: </label>                                 
                                <textarea id="sort_description" name="sort_description" class="form-control" rows="3"><?php echo $room['sort_description']; ?></textarea> 

                            </div>

                            <div class="form-group">
                                <label for="description" >Description: </label>                                 
                                <textarea id="description" name="description" class="form-control" rows="5"><?php echo $room['description']; ?> </textarea> 

                            </div>

                            <button type="submit" name="save-data" value="Save" class="btn btn-default">Save</button> 
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!--end new image add form-->



    </div>
    <!--end container-->
</div>
<!--END MAIN SITE WRAPPER-->

<?php
include './footer.php';
