<?php
include './header.php';

$imgName = NULL;
$success = NULL;
$error = NULL;


if (isset($_POST['save-data'])) {

    $gestcomment = addNewComment($_POST, $_FILES);

    if ($gestcomment) {
        $success = 'Successfully added new Comment';
    } else {
        $error = 'Something went wrong, please try again ';
    }
}
?>

<!-- MAIN SITE WRAPPER-->
<div class="content-wrapper">

    <!--container-->
    <div class="container">
        <!--banner-->
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">Guest Comments </h1>
            </div>
        </div>
        <!--end banner-->


        <!--new image add form-->
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        Add New Comments
                    </div>
                    <div class="panel-body">
                        <form method="post" action="" enctype="multipart/form-data">

                            <div class="form-group">
                                <?php if (isset($success)) { ?>

                                    <div class="alert alert-success" style="margin-top: 15px ">
                                        <a href="" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                        <strong>Success! </strong> <?php echo $success; ?>
                                    </div>

                                <?php } ?>
                                
                                <?php if (isset($error)) { ?>

                                    <div class="alert alert-danger" style="margin-top: 15px ">
                                        <a href="" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                        <strong>Try again! </strong> <?php echo $error; ?>
                                    </div>

                                <?php } ?>
                            </div>

                            <div class="form-group">
                                <label for="imageName">Select Image</label>
                                <input name="image" type="file" id="exampleInputFile" />
                                <p class="help-block">Automaticity cropping this image 100 X 100 pixels</p>
                            </div> 

                            <div class="form-group">
                                <label for="imageTitle">Name</label>
                                <input type="text" name="name" class="form-control" id="exampleInputEmail1" placeholder="Enter Image Title" />
                            </div> 
 
                            <div class="form-group">
                                <label for="comment" >Description: </label>                                 
                                <textarea name="comment" class="form-control" rows="5" required="TRUE"></textarea> 

                            </div>

                            <button type="submit" name="save-data" value="Save" class="btn btn-default">Save</button> 
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!--end new image add form-->

        <!--view slider image -->
        <div class="panel panel-default"> 
            <div class="panel-body"> 

                <div class="row"> 
                    <?php
                    $gestcomments = getAllComments(); 
                    
                    if (count($gestcomments) > 0) {
                        foreach ($gestcomments as $comment) {
                            ?>
                            <div class="col-md-3 col-sm-4 col-xs-6">
                                <div class="slider-image">
                                <a class="info" class="example-image-link" data-lightbox="example-set"  href="../images/comments/<?php echo $comment["image_name"]; ?>" > 
                                    <img class="example-image img-responsive" src="../images/comments/<?php echo $comment["image_name"]; ?>" alt=""/> 
                                </a> 
                                </div>  
                                
                                <div class="image-option " > 
                                    <p class="maxlinetitle"><?php echo $comment["name"]; ?></p>
                                    <button class="glyphicon glyphicon-trash delete text-danger delete-comment" id="<?php echo $comment["image_name"]; ?>"></button>
                                    <a href="edit-comment.php?id=<?php echo $comment["id"]; ?>"><button class="glyphicon glyphicon-pencil edit"></button></a>
                                    <a href="arrange-comment.php"><button class="glyphicon glyphicon-sort pictuers"></button></a>
                                </div>
                                 
                            </div> 
                            <?php
                        }
                    } else {
                        ?> 
                        <b>No comments in the database.</b> 
                    <?php } ?> 

                </div>
            </div>
        </div>
        <!--end view slider image -->

    </div>
    <!--end container-->
</div>
<!--END MAIN SITE WRAPPER-->

<?php
include './footer.php';
