<?php
include './header.php';

$imgName = NULL;
$success = NULL;
$error = NULL;

if (isset($_POST['save-data'])) {

    $rooms = addNewRoom($_POST, $_FILES);

    if ($rooms) {
        $success = 'New room was created successfully';
    } else {
        $error = 'Something went wrong, please try again ';
    }
} 
?> 
<script src="tinymce/js/tinymce/tinymce.min.js"></script>
<script>

    tinymce.init({
        selector: "#description",
        // ===========================================
        // INCLUDE THE PLUGIN
        // ===========================================

        plugins: [
            "advlist autolink lists link image charmap print preview anchor",
            "searchreplace visualblocks code fullscreen",
            "insertdatetime media table contextmenu paste"
        ],
        // ===========================================
        // PUT PLUGIN'S BUTTON on the toolbar
        // ===========================================

        toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image jbimages",
        // ===========================================
        // SET RELATIVE_URLS to FALSE (This is required for images to display properly)
        // ===========================================

        relative_urls: false

    });

</script>
<!-- MAIN SITE WRAPPER-->
<div class="content-wrapper">

    <!--container-->
    <div class="container">
        <!--banner-->
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">Rooms</h1>
            </div>
        </div>
        <!--end banner-->
 
        <!--new image add form-->
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        Add New Room
                    </div>
                    <div class="panel-body">
                        <form method="post" action="" enctype="multipart/form-data">

                            <div class="form-group">
                                <?php if (isset($success)) { ?>

                                    <div class="alert alert-success" style="margin-top: 15px ">
                                        <a href="" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                        <strong>Success! </strong> <?php echo $success; ?>
                                    </div>

                                <?php } ?>
                                
                                <?php if (isset($error)) { ?>

                                    <div class="alert alert-danger" style="margin-top: 15px ">
                                        <a href="" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                        <strong>Try again! </strong> <?php echo $error; ?>
                                    </div>

                                <?php } ?>
                            </div>

                            <div class="form-group">
                                <label for="imageName">Select Image</label>
                                <input name="image" type="file" id="imageName" required />
                                <p class="help-block">Automaticity cropping this image 360 X 240 pixels</p>
                            </div> 

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" class="form-control" id="title" placeholder="Enter Room Name" required/>
                            </div> 
                            
                            <div class="form-group">
                                <label for="price">Price - BB</label>
                                <input type="text" name="price" class="form-control" id="price" placeholder="Enter Room Price - BB" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="priceRO">Price - Room Only</label>
                                <input type="text" name="priceRO" class="form-control" id="priceRO" placeholder="Enter Room Price - Room Only" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="extraBeds">Number of Extra Beds</label>
                                <input type="text" name="extraBeds" class="form-control" id="extraBeds" placeholder="Enter Number of Extra Beds" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="extraBedPrice">Price of a Extra Bed</label>
                                <input type="text" name="extraBedPrice" class="form-control" id="extraBedPrice" placeholder="Enter Price of a Extra Beda" required/>
                            </div>
                            
                            <div class="form-group">
                                <label for="numOfRoom">Number of Rooms</label>
                                <input type="text" name="numOfRoom" class="form-control" id="numOfRoom" placeholder="Enter Number of Rooms" required/>
                            </div>
                            <div class="form-group">
                                <label for="sort_description" >Short Description: </label>                                 
                                <textarea id="sort_description" name="sort_description" class="form-control" rows="3" required></textarea> 

                            </div>

                            <div class="form-group">
                                <label for="description" >Description: </label>                                 
                                <textarea id="description" name="description" class="form-control" rows="5"></textarea> 

                            </div>

                            <button type="submit" name="save-data" value="Save" class="btn btn-default">Add</button> 
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!--end new image add form-->

        <!--view slider image -->
        <div class="panel panel-default"> 
            <div class="panel-body"> 

                <div class="row"> 
                    <?php
                    $rooms = getAllRooms(); 
                    
                    if (count($rooms) > 0) {
                        foreach ($rooms as $room) {
                            ?>
                            <div class="col-md-3 col-sm-4 col-xs-6">
                                <div class="slider-image">                                
                                    <img class="img-responsive" src="../images/rooms/<?php echo $room["image_name"]; ?>" alt=""/>                                  
                                </div>  
                                
                                <div class="image-option " > 
                                    <p class="maxlinetitle"><?php echo $room["title"]; ?></p>
                                    <button class="glyphicon glyphicon-trash delete text-danger delete-room" id="<?php echo $room["id"]; ?>"></button>
                                    <a href="edit-room.php?id=<?php echo $room["id"]; ?>"><button class="glyphicon glyphicon-pencil edit"></button></a>                                    
                                    <a href="add-room-photos.php?id=<?php echo $room["id"]; ?>"><button class="glyphicon glyphicon-picture pictuers"></button></a>
                                </div>
                                 
                            </div> 
                            <?php
                        }
                    } else {
                        ?> 
                    <b style="padding-left: 15px;">No Rooms in the database.</b> 
                    <?php } ?> 

                </div>
            </div>
        </div>
        <!--end view slider image -->

    </div>
    <!--end container-->
</div>
<!--END MAIN SITE WRAPPER-->

<?php
include './footer.php';
