<?php
include './db.php';
include './function.php';

$welcomenote = getWelcomeNote();

$services = getAllServices();

$activities = getAllActivities();

$rooms = getAllRooms();

$comments = getAllComments();
?>

<!DOCTYPE html>
<html lang="en">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">   
    <meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Ahangama Hotels | Ahangama Villa | Ahangama Villa Effort</title>  
    <meta name="keywords" content="villa effort Ahangama, Ahangama villa effort, Ahangama villa, Ahangama villas, Ahangama hotels, hotels in Ahangama, Sri Lanka Eco Villa, Surfing in Ahangama, surfing beach Ahangama, luxury rooms in Ahangama, Ahangama luxury rooms, things to do in Ahangama, Luxury Rooms in Ahangama, Ahangama, Ahangama, Budget villa in Ahangama, Budget Hotels in Ahangama, Galle, Unawatuna, Unawatuna serfing beach, whales waching mirissa, mirissa whales waching, things to do in sri lanka">
    <meta name="description" content="Villa Effort an ideal location for great relaxation with tranquility boutique hotel by serving unique, ultimate service which located near Ahangama a 30 minutes’ drive from Galle Historical city. ">
    <meta name="author" content="">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon.png">
    <link rel="stylesheet" type="text/css" href="revolution/css/settings.css">
    <link rel="stylesheet" type="text/css" href="revolution/css/layers.css">
    <link rel="stylesheet" type="text/css" href="revolution/css/navigation.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="css/colors.css">
    <link rel="stylesheet" href="css/custom.css">

</head>
<body>  
    <div id="preloader">
        <img class="preloader" src="images/loader.gif" alt="">
    </div> 
    <div id="wrapper"> 
        <?php include './header.php'; ?> 
        <?php include './main-slider.php'; ?> 

        <div class="section wb">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="about-widget">
                            <div class="big-title">
                                <h3><?php echo $welcomenote['title']; ?></h3>
                            </div>
                            <p class="text-justify"><?php echo $welcomenote['description']; ?></p>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-xs-12"> 
                        <iframe width="100%" height="315" style="margin-top: 30px;" src="https://www.youtube.com/embed/BQLmhKG_Z2A" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>

                    </div>
                </div>
            </div>
        </div>

        <div class="section lb parallax-room">
            <div class="dot-layer"></div>
            <div class="container">
                <div class="section-title text-center">
                    <h3 style="color: #fff">ACCOMMODATIONS</h3>  
                </div>       

                <div class="row blog-wrapper">
                    <div class="col-md-2"></div>
                    <?php
                    foreach ($rooms as $key => $room) {
                        if ($key < 2) {
                            ?>
                            <div class="col-md-4 col-sm-6 col-xs-12 wow fadeIn center-block">
                                <a href="accomodation.php?id=1#tab-content">
                                    <div class="about-widget room-section">
                                        <div class="post-media entry">
                                            <img src="images/rooms/<?php echo $room['image_name']; ?>" alt="" class="img-responsive">

                                        </div>
                                        <div class="romm-details">
                                            <div class="small-title">
                                                <h4><a href="accomodation.php?id=1#tab-content"><?php echo $room['title']; ?></a></h4>
                                            </div>
                                            <p class="text-justify">
                                                <?php
                                                if (strlen($room['sort_description']) > 0) {
                                                    echo substr($room['sort_description'], 0, 100) . '...';
                                                } else {
                                                    echo $room['sort_description'];
                                                }
                                                ?>
                                            </p>

                                            <a class="btn btn-default btn-sm pull-left" href="accomodation.php?id=1#tab-content">Read More</a>
                                            <p class="readmore pull-right">Per Night<span> $<?php echo $room['priceRO']; ?></span></p>

                                        </div>
                                    </div>
                                </a> 
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
                <div class="col-md-11 view-all  center-block text-center col-md-offset-4">
                    <a href="accomodation.php?id=1#tab-content" style="z-index: 9999; position: absolute" class="btn btn-primary">View All</a>
                </div>
            </div>
        </div>

        <div class="section wb">
            <div class="container">
                <div class="section-title text-center">
                    <h3>ACTIVITIES</h3> 
                </div> 

                <div class="section-widget text-center">
                    <div class="row">
                        <?php
                        foreach ($activities as $key => $activitiy) {
                            if ($key < 4) {
                                ?>
                                <div class="col-md-3 col-sm-6 col-xs-12 wow fadeIn">
                                    <div class="about-widget activities">
                                        <div class="post-media entry">
                                            <a href="view-activitiy.php?id=<?php echo $activitiy['id']; ?>"><img src="images/activities/<?php echo $activitiy['image_name']; ?>" alt="" class="img-responsive img-rounded"></a>
                                        </div>
                                        <div class="small-title">
                                            <h4><a href="view-activitiy.php?id=<?php echo $activitiy['id']; ?>"><?php echo $activitiy['title']; ?></a></h4>
                                        </div>
                                        <p class="text-justify">
                                            <?php
                                            if (strlen($activitiy['sort_description']) > 0) {
                                                echo substr($activitiy['sort_description'], 0, 90) . '...';
                                            } else {
                                                echo $activitiy['sort_description'];
                                            }
                                            ?>
                                        </p>
                                        <a class="readmore pull-right" href="view-activity.php?id=<?php echo $activitiy['id']; ?>">Read More</a>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="pricing-box-03-foot center-block view-all">
                        <a href="activities.php" class="btn btn-primary">View All</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="section lb parallax">
            <div class="dot-layer"></div>
            <div class="container">
                <div class="section-title text-center">
                    <h3 style="color: #fff">SERVICES</h3> 
                </div>     
                <div class="row team-members">
                    <?php
                    foreach ($services as $key => $service) {
                        if ($key < 4) {
                            ?>
                            <div class="col-md-3 col-sm-6 col-xs-12 wow fadeIn">
                                <div class="hoverbox parallax parallax-off" data-stellar-background-ratio="1" style="background-image:url('images/services/<?php echo $service['image_name']; ?>');">
                                    <div class="box">
                                        <div class="box-content">
                                            <i class="flaticon-forest"></i>
                                            <h2><span><?php echo $service['title']; ?></span></h2>
                                        </div>
                                        <div class="box-back">
                                            <p class="text-justify">
                                                <?php
                                                if (strlen($service['shortDescription']) > 0) {
                                                    echo substr($service['shortDescription'], 0, 100) . '...';
                                                } else {
                                                    echo $service['shortDescription'];
                                                }
                                                ?>
                                            </p>
                                            <a class="readmore" href="services.php?id=<?php echo $service['id']; ?>">Read More</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                        <?php
                    }
                    ?>
                </div>
                <div class="col-md-11 view-all  center-block text-center col-md-offset-4">
                    <a href="services.php" class="btn btn-primary" style="z-index: 9999; position: absolute;">View All</a>
                </div>
            </div>
        </div>

        <section class="comment">
            <div class="container">
                <div class="section-title text-center">
                    <h3 style="color: #000">GUEST COMMENTS</h3>
                </div>
                <div class='col-md-7'> 
                    <div class="owl-carousel"> 
                        <?php
                        foreach ($comments as $key => $comment) {
                            ?>
                            <div class="item active">
                                <blockquote>
                                    <div class="row">
                                        <div class="col-sm-3 text-center col-md-3">
                                            <img class="img-circle pull-right img-responsive" src="images/comments/<?php echo $comment['image_name']; ?>" alt="<?php echo $comment['name']; ?>" style="width: 100px;height:100px;">
                                        </div>
                                        <div class="col-sm-7 col-md-7">
                                            <p class="text-justify comment-box"><?php echo $comment['comment']; ?></p>
                                            <small><?php echo $comment['name']; ?></small>
                                        </div>
                                        <div class="col-sm-2"></div>
                                    </div>
                                </blockquote>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
                <div class='col-md-5'>
                     <iframe width="100%" height="315" style="margin-top: 30px;" src="https://www.youtube.com/embed/nEAmO44gIc8" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>

                </div>
            </div>
        </section>
        <?php include './footer.php'; ?>

    </div>


    <script src="js/all.js"></script>
    <script src="js/custom.js"></script> 

    <script type="text/javascript" src="revolution/js/jquery.themepunch.tools.min.js"></script>
    <script type="text/javascript" src="revolution/js/jquery.themepunch.revolution.min.js"></script>
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.actions.min.js"></script>
<!--    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.carousel.min.js"></script>-->
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.migration.min.js"></script>
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.navigation.min.js"></script>
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.parallax.min.js"></script>
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
    <script type="text/javascript" src="revolution/js/extensions/revolution.extension.video.min.js"></script>
    <script type="text/javascript">
        var tpj = jQuery;
        var revapi4;
        tpj(document).ready(function () {
            if (tpj("#rev_slider_4_1").revolution == undefined) {
                revslider_showDoubleJqueryError("#rev_slider_4_1");
            } else {
                revapi4 = tpj("#rev_slider_4_1").show().revolution({
                    sliderType: "standard",
                    jsFileLocation: "revolution/js/",
                    sliderLayout: "fullwidth",
                    dottedOverlay: "none",
                    delay: 4500,
                    navigation: {
                        keyboardNavigation: "off",
                        keyboard_direction: "horizontal",
                        mouseScrollNavigation: "off",
                        onHoverStop: "off",
                        touch: {
                            touchenabled: "on",
                            swipe_threshold: 75,
                            swipe_min_touches: 1,
                            swipe_direction: "horizontal",
                            drag_block_vertical: false
                        }
                        ,
                        arrows: {
                            style: "zeus",
                            enable: true,
                            hide_onmobile: true,
                            hide_under: 600,
                            hide_onleave: true,
                            hide_delay: 200,
                            hide_delay_mobile: 1200,
                            tmp: '<div class="tp-title-wrap">    <div class="tp-arr-imgholder"></div> </div>',
                            left: {
                                h_align: "left",
                                v_align: "center",
                                h_offset: 30,
                                v_offset: 0
                            }
                            ,
                            right: {
                                h_align: "right",
                                v_align: "center",
                                h_offset: 30,
                                v_offset: 0
                            }
                        }
                        ,
                        bullets: {
                            enable: true,
                            hide_onmobile: true,
                            hide_under: 600,
                            style: "metis",
                            hide_onleave: true,
                            hide_delay: 200,
                            hide_delay_mobile: 1200,
                            direction: "horizontal",
                            h_align: "center",
                            v_align: "bottom",
                            h_offset: 0,
                            v_offset: 30,
                            space: 5,
                            tmp: '<span class="tp-bullet-img-wrap">  <span class="tp-bullet-image"></span></span><span class="tp-bullet-title">{{title}}</span>'
                        }
                    }
                    ,
                    viewPort: {
                        enable: true,
                        outof: "pause",
                        visible_area: "80%"
                    }
                    ,
                    responsiveLevels: [1240, 1024, 778, 480],
                    gridwidth: [1240, 1024, 778, 480],
                    gridheight: [600, 600, 500, 400],
                    lazyType: "none",
                    parallax: {
                        type: "mouse",
                        origo: "slidercenter",
                        speed: 2000,
                        levels: [2, 3, 4, 5, 6, 7, 12, 16, 10, 50],
                    }
                    ,
                    shadow: 0,
                    spinner: "off",
                    stopLoop: "off",
                    stopAfterLoops: -1,
                    stopAtSlide: -1,
                    shuffle: "off",
                    autoHeight: "off",
                    hideThumbsOnMobile: "off",
                    hideSliderAtLimit: 0,
                    hideCaptionAtLimit: 0,
                    hideAllCaptionAtLilmit: 0,
                    debugMode: false,
                    fallbacks: {
                        simplifyAll: "off",
                        nextSlideOnWindowFocus: "off",
                        disableFocusListener: false,
                    }
                }
                );
            }
        }
        );
        /*ready*/
    </script>


    <link rel="stylesheet" href="owlcarousel/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="owlcarousel/assets/owl.theme.default.min.css">
    <script src="owlcarousel/owl.carousel.min.js"></script>

    <script type="text/javascript">

        $('.owl-carousel').owlCarousel({
            loop: true,
            margin: 10,
            autoplay: true,
            autoHeight: true,
            autoplayHoverPause: true,
            responsive: {
                0: {
                    items: 1,
                    nav: true
                },
                600: {
                    items: 1,
                    nav: true
                },
                1000: {
                    items: 1,
                    nav: true,
                }
            }
        });

    </script>

</body>
</html>