jQuery(document).ready(function () {

    jQuery('.btn-next').click(function () {
        var btnId = this.id;
        var onlyId = btnId.replace('btn-next-', '');
        if (onlyId === '2') {
            var res = validateRoomsDetails();
            if (res) {
                jQuery('#btnTabbed_' + onlyId).click();
                jQuery('#btnTabbed_' + onlyId).removeClass('not-active');

            }
        }
        if (onlyId === '3') {
            var res = validateYourDetails();
            if (res) {
                jQuery('#btnTabbed_' + onlyId).click();
                jQuery('#btnTabbed_' + onlyId).removeClass('not-active');
            }
        }
    });

    jQuery('.btn-previous').click(function () {
        var btnId = this.id;
        var onlyId = btnId.replace('btn-previous-', '');
        jQuery('#btnTabbed_' + onlyId).click();
    });

    jQuery('.rooms').change(function () {
        setRoomGuests();
        setGuestDetails();
        calPrice();
    });

    jQuery('#btn-submit').click(function () {
        var result = validatePaymentDetails();
        if (result) {
            $('#formReser').submit();
        }
    });

});

function calPrice() {

    var tot = 0;
    var rooms = 0;

    $(".rooms").each(function (index) {

        var values = this.value.split('US$');
        if (values[1]) {

            tot = parseInt(tot) + parseInt(values[1]);
            rooms = parseInt(rooms) + parseInt(values[0]);
        }
    });

    var vat = tot * (15 / 100);

    $('#totSubTotal').text(tot.toFixed(2));
    $('#vat').text(vat.toFixed(2));

    var total = vat + tot;
    $('#totPrice').text(total);
    $('#txtPrice').val(total);

    if (total === 0) {
        $('#txtPrice').val("");
    }

    $('#totRooms').text(rooms);
}

function setRoomGuests() {

    $(".rooms_hd_class").each(function (index) {

        var catid = this.id;
        var onlyId = catid.replace('rooms_hd_class_', '');

        var rooms = 0;

        $(".rooms_op_class_" + onlyId).each(function (index) {

            var values = this.value.split('US$');

            if (values[0]) {
                rooms = parseInt(rooms) + parseInt(values[0]);
            }

            $('#rooms_hd_class_' + onlyId).val(rooms);

        });

    });

}

function setGuestDetails() {

    var html = '<hr/><h2>Rooms Details</h2>';

    $(".rooms_hd_class").each(function (index) {

        var catid = this.id;
        var onlyId = catid.replace('rooms_hd_class_', '');
        var numRoom = this.value;
        var roomName = jQuery('#roomTi_' + onlyId).text();

        var i = 0;

        while (i < numRoom) {
            html += "<div class='panel-group'>";
            html += "<div class='panel panel-default'>";
            html += "<div class='panel-body'>" + roomName + "</div>";
            html += "<inpu type='hidden' value='" + roomName + "' name='room_name[]'>";
            html += "</div>";

            html += "<div class='panel panel-default'>";
            html += "<div class='row form-group panel-body'>";


            html += "<div class='col-xs-12 col-sm-3'>";
            html += "<label>Number of Guest</label>";
            html += "<select class='form-control' name='numberOfGuest[]'><option value='1'>1</option> <option value='2' selected>2</option></select>";
            html += "</div>";

            html += "<div class='col-xs-12 col-sm-3'>";
            html += "<label>Number of Extra Beds</label>";
            html += "<select class='form-control' name='numberExtraBeds[]'><option value='0' selected>0</option> <option value='1'>1</option></select>";
            html += "</div>";

            html += "<div class='col-xs-12 col-sm-6'>";
            html += "<label>Guest Name</label>";

            html += "<input type='text' id='guestName_" + i + catid + "' class='form-control guest-name' name='GuestName[]'><span id='guestNameSpan_" + i + catid + "'></span>";
            html += "</div>";

            html += "</div>";
            html += "</div>";
            html += "</div>";
            html += "</div>";
            i++;
        }
    });

    $('#guest-details').empty();
    $('#guest-details').append(html);
}

function validateRoomsDetails() {

    if (
            validateEmpty("txtDDate", "spanDDate", "Arrival date can not be empty") &
            validateEmpty("txtADate", "spanADate", "Departure date can not be empty") &
            validateEmpty("txtPrice", "spanRoom", "Please select even one room to prossed the booking")

            )
    {
        var resArr = '';

        $(".guest-name").each(function (index) {
            var idg = this.id;
            var onlyId = idg.replace('guestName_', '');
            var result = validateEmpty(idg, "guestNameSpan_" + onlyId, "This field can not be empty");
            resArr += result + " , ";
        });

        if (resArr.search('false') === -1) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}


function validateYourDetails() {
    if (
            validateEmpty("txtName", "spanName", "Name can not be empty") &
            ValidateEmail("txtEmail", "spanEmail") &
            validateEmpty("txtCountry", "spanCountry", "Country can not be empty") &
            validateEmpty("txtPhone", "spanPhone", "Phone can not be empty")
            )
    {
        return true;
    } else {
        return false;
    }
}


function validatePaymentDetails() {
    if (
            validateEmpty("txtCardType", "spanCardType", "Card type can not be empty") &
            validateEmpty("txtCardNumber", "spanCardNumber", "Card number can not be empty") &
            validateEmpty("txtCardHolderName", "spanCardHolderName", "Card holder name can not be empty") &
            validateEmpty("txtExpirationDate", "spanExpirationDate", "Expiration date can not be empty") &
            validateEmpty("txtCVCCode", "spanCVCCode", "CVC code can not be empty")
            )
    {
        return true;
    } else {
        return false;
    }
}

function validateEmpty(field, validatorspan, mess)
{
    if (jQuery('#' + field).val().length != 0)
    {
        jQuery('#' + validatorspan).addClass("validated");
        jQuery('#' + validatorspan).removeClass("notvalidated");
        jQuery('#' + validatorspan).fadeIn('slow').fadeOut(4500);
        jQuery('#' + validatorspan).text("");

        return true;
    } else
    {
        jQuery('#' + validatorspan).addClass("notvalidated");
        jQuery('#' + validatorspan).removeClass("validated");
        jQuery('#' + validatorspan).fadeIn('slow').fadeOut(4500);
        jQuery('#' + validatorspan).text(mess);

        return false;
    }
}

//--------------------------------------------------function to check email--------------------------------------------------

function ValidateEmail(field, validatordiv)
{
    var mailformat = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
    if (jQuery('#' + field).val().match(mailformat))
    {
        jQuery('#' + validatordiv).addClass("validated");
        jQuery('#' + validatordiv).removeClass("notvalidated");
        jQuery('#' + validatordiv).fadeIn('slow').fadeOut(4500);
        jQuery('#' + validatordiv).text("");
        return true;
    } else
    {
        jQuery('#' + validatordiv).addClass("notvalidated");
        jQuery('#' + validatordiv).removeClass("validated");
        jQuery('#' + validatordiv).fadeIn('slow').fadeOut(4500);
        jQuery('#' + validatordiv).text("You have entered an invalid Email Address");

        return false;
    }
}
